﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Data.SqlClient;
using System.Security.Cryptography;
using System.Data.Common;
using Percent___Qualification_work.Classes;
using System.Data.Odbc;
using Percent___Qualification_work.Forms;

namespace Percent___Qualification_work
{
    public partial class LoginForm : Form
    {
        private Authentication authentication;
        private databaseConnection dbConnection;
        public LoginForm()
        {
            InitializeComponent();

            SUbutton.Enabled = false;
            Lbutton.Enabled = false;
            dbConnection = new databaseConnection();
            authentication = new Authentication();
            SUusername.TextChanged += new EventHandler(enableSUButton);
            SUpassword.TextChanged += new EventHandler(enableSUButton);
            SUpassword1.TextChanged += new EventHandler(enableSUButton);
            Lusername.TextChanged += new EventHandler(enableLbutton);
            Lpassword.TextChanged += new EventHandler(enableLbutton);


        }
        
        //SIGNUP

        // Check if all input fields in signup window are not empty to enable the signup button
        private void enableSUButton(object sender, EventArgs e)
        {
            SUbutton.Enabled = !string.IsNullOrEmpty(SUusername.Text) &&
                               !string.IsNullOrEmpty(SUpassword.Text) &&
                               !string.IsNullOrEmpty(SUpassword1.Text);
        }

        private void LoginForm_Load(object sender, EventArgs e)
        {
            this.Lusername.AutoSize = this.Lpassword.AutoSize = this.SUusername.AutoSize = this.SUpassword.AutoSize = this.SUpassword1.AutoSize = false;
            this.Lusername.Size = this.Lpassword.Size = this.SUusername.Size = this.SUpassword.Size = this.SUpassword1.Size = new System.Drawing.Size(156,26);
        }

        // Display SignUp window when "Don't have an account yet?" text is clicked
        private void LtoSU_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            Lpanel.Visible = false;
        }

        // Display Login window when "Already have an account?" text is clicked
        private void SUtoL_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            Lpanel.Visible=true;
        }

        private void SUbutton_Click(object sender, EventArgs e)
        {
            string[] checkSymbols = { "!", "@", "#", "$", "%", "^", "&", "*", "(", ")" };
    
            // Collect data from input fields
            string username = SUusername.Text;
            string password = SUpassword.Text;
            string password1 = SUpassword1.Text;

            // Check if password meets all requirements
            bool isValidPassword = password.Length >= 8 &&
                                   checkSymbols.Any(symbol => password1.Contains(symbol)) &&
                                   password.Any(char.IsDigit) &&
                                   password.Any(char.IsUpper);
            
            // Check if the password don't match
            if (password != password1 )
            {
                isValidPassword = false;
                MessageBox.Show("Passwords do not match!");
                return;
            }

            // Check if an account with this username doesnt exist
            if (dbConnection.IsUsernameTaken(username))
            {
                MessageBox.Show("Username is already taken, please choose a different one.");
                return; 
            }


            if (isValidPassword)
            {
                bool isRegistered = authentication.Register(username, password);

                if(isRegistered) 
                {
                    MessageBox.Show("Registration successful! Please log in!");
                    SUusername.Text = "";
                    SUpassword.Text = "";
                    SUpassword1.Text = "";
                    Lpanel.Visible = true;
                }
                else
                {
                    MessageBox.Show("There was an error creating an account! Try again later...");
                }


            }
            else
            {
                string errorMessage = "Your password:\n";
                if (password1.Length < 8) errorMessage += "- Must be at least 8 characters long\n";
                if (!checkSymbols.Any(symbol => password1.Contains(symbol))) errorMessage += "- Is missing a special symbol (!, @, #, $, etc.)\n";
                if (!password1.Any(char.IsDigit)) errorMessage += "- Is missing atleast one number\n";
                if (!password1.Any(char.IsUpper)) errorMessage += "- Is missing atleast one uppercase letter";

                MessageBox.Show(errorMessage);

            }

        }

        private void passwordClue_Click(object sender, EventArgs e)
        {
            MessageBox.Show("Password must: \n" +
                "Be atleast 8 symbols long\n" +
                "Contain atleast 1 number\n" +
                "Contain atleast 1 uppercase letter\n" +
                "Contain atleast 1 special symbol(!,@,#,$,%,^,&,*,(,))");
        }


        //LOGIN

        private void enableLbutton(object sender, EventArgs e)
        {
            Lbutton.Enabled = !string.IsNullOrEmpty(Lusername.Text) &&
                              !string.IsNullOrEmpty(Lpassword.Text);  
        }
        private void Lbutton_Click(object sender, EventArgs e)
        {
            string username = Lusername.Text;
            string password = Lpassword.Text;

            if (authentication.Login(username, password))
            {
                MessageBox.Show("Login successful!");

                this.DialogResult = DialogResult.OK;


                this.Close();
            }
        }



    }
}
